// Test script for anonymous ticket creation
const fetch = require("node-fetch");

async function testAnonymousTicket() {
  const response = await fetch("http://localhost:3000/api/tickets/create", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({
      title: "Test Anonymous Ticket",
      description: "This is a test ticket created by an anonymous user",
      location: "Emergency Room",
      severity: 3,
      department: "Emergency",
      anonymousEmail: "patient@example.com",
      anonymousName: "Anonymous Patient",
      attachments: [],
    }),
  });

  const result = await response.json();
  console.log("Response:", result);
}

testAnonymousTicket().catch(console.error);
